export declare class ImportEntry {
    readonly path: string;
    readonly isTry: boolean;
    readonly entryType = "import";
    constructor(path: string, isTry: boolean);
}
export declare class BazelOption {
    readonly name: string;
    readonly value?: string | undefined;
    constructor(name: string, value?: string | undefined);
    static parse(input: string): BazelOption[];
}
export declare class CommandEntry {
    readonly command: string;
    readonly options: BazelOption[];
    readonly config?: string | undefined;
    readonly entryType = "command";
    constructor(command: string, options: BazelOption[], config?: string | undefined);
    getOption(name: string): BazelOption | undefined;
}
type BazelrcEntries = ImportEntry | CommandEntry;
export declare function expandWorkspacePath(value: string, workspaceDir: string): string | null;
export declare function sanitizeOptions(options: BazelOption[], workspaceDir: string): BazelOption[];
export declare function parse(contents: string): BazelrcEntries[];
export declare function read(workspaceDir: string): Promise<CommandEntry[]>;
export {};
