import { z } from 'zod';
import type { PackageDependency } from '../types';
export declare const BatectConfigSchema: z.ZodEffects<z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodObject<{
    containers: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>, string[], Record<string, any>>>;
    include: z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
        type: "git";
        ref: string;
        repo: string;
    } | {
        path: string;
        type: "file";
    } | {
        type: "file";
        path: string;
    })[], any[]>>;
}, "strip", z.ZodTypeAny, {
    containers: string[];
    include: ({
        type: "git";
        ref: string;
        repo: string;
    } | {
        path: string;
        type: "file";
    } | {
        type: "file";
        path: string;
    })[];
}, {
    containers?: unknown;
    include?: unknown;
}>>, {
    imageDependencies: PackageDependency<Record<string, any>>[];
    bundleDependencies: PackageDependency<Record<string, any>>[];
    fileIncludes: string[];
}, string>;
export type BatectConfig = z.infer<typeof BatectConfigSchema>;
