"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
exports.extractAllPackageFiles = extractAllPackageFiles;
const tslib_1 = require("tslib");
const upath_1 = tslib_1.__importDefault(require("upath"));
const logger_1 = require("../../../logger");
const fs_1 = require("../../../util/fs");
const schema_1 = require("./schema");
function extractPackageFile(content, packageFile) {
    logger_1.logger.trace(`batect.extractPackageFile(${packageFile})`);
    try {
        const { imageDependencies, bundleDependencies, fileIncludes } = schema_1.BatectConfigSchema.parse(content);
        const deps = [...imageDependencies, ...bundleDependencies];
        const dirName = upath_1.default.dirname(packageFile);
        const referencedConfigFiles = fileIncludes.map((file) => upath_1.default.join(dirName, file));
        return { deps, referencedConfigFiles };
    }
    catch (err) {
        logger_1.logger.debug({ err, packageFile }, 'Extracting dependencies from Batect configuration file failed');
        return null;
    }
}
async function extractAllPackageFiles(config, packageFiles) {
    const filesToExamine = new Set(packageFiles);
    const filesAlreadyExamined = new Set();
    const results = [];
    while (filesToExamine.size > 0) {
        const packageFile = filesToExamine.values().next().value;
        filesToExamine.delete(packageFile);
        filesAlreadyExamined.add(packageFile);
        const content = await (0, fs_1.readLocalFile)(packageFile, 'utf8');
        // TODO #22198
        const result = extractPackageFile(content, packageFile);
        if (result !== null) {
            result.referencedConfigFiles.forEach((f) => {
                if (!filesAlreadyExamined.has(f) && !filesToExamine.has(f)) {
                    filesToExamine.add(f);
                }
            });
            results.push({
                packageFile,
                deps: result.deps,
            });
        }
    }
    return results;
}
//# sourceMappingURL=extract.js.map