"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateArtifacts = updateArtifacts;
const logger_1 = require("../../../logger");
const http_1 = require("../../../util/http");
const http = new http_1.Http('batect-wrapper');
async function updateArtifact(path, fileName, version) {
    const url = `https://github.com/batect/batect/releases/download/${version}/${fileName}`;
    try {
        const response = await http.getText(url);
        const contents = response.body;
        return {
            file: { type: 'addition', path, contents },
        };
    }
    catch (err) {
        const errorDescription = err.toString();
        return {
            artifactError: {
                lockFile: path,
                stderr: `HTTP GET ${url} failed: ${errorDescription}`,
            },
        };
    }
}
async function updateArtifacts({ packageFileName, config, }) {
    const version = config.newVersion;
    logger_1.logger.debug(`Updating Batect wrapper scripts for ${packageFileName} to ${version}`);
    return [
        await updateArtifact(packageFileName, 'batect', version),
        await updateArtifact(`${packageFileName}.cmd`, 'batect.cmd', version),
    ];
}
//# sourceMappingURL=artifacts.js.map