"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.url = exports.displayName = exports.extractPackageFile = void 0;
const dart_version_1 = require("../../datasource/dart-version");
const docker_1 = require("../../datasource/docker");
const dotnet_version_1 = require("../../datasource/dotnet-version");
const flutter_version_1 = require("../../datasource/flutter-version");
const github_releases_1 = require("../../datasource/github-releases");
const github_tags_1 = require("../../datasource/github-tags");
const hexpm_bob_1 = require("../../datasource/hexpm-bob");
const java_version_1 = require("../../datasource/java-version");
const node_version_1 = require("../../datasource/node-version");
const npm_1 = require("../../datasource/npm");
const pypi_1 = require("../../datasource/pypi");
const ruby_version_1 = require("../../datasource/ruby-version");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'asdf';
exports.url = 'https://asdf-vm.com';
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)\\.tool-versions$/'],
};
exports.supportedDatasources = [
    dart_version_1.DartVersionDatasource.id,
    docker_1.DockerDatasource.id,
    dotnet_version_1.DotnetVersionDatasource.id,
    flutter_version_1.FlutterVersionDatasource.id,
    github_releases_1.GithubReleasesDatasource.id,
    github_tags_1.GithubTagsDatasource.id,
    hexpm_bob_1.HexpmBobDatasource.id,
    java_version_1.JavaVersionDatasource.id,
    node_version_1.NodeVersionDatasource.id,
    npm_1.NpmDatasource.id,
    pypi_1.PypiDatasource.id,
    ruby_version_1.RubyVersionDatasource.id,
];
//# sourceMappingURL=index.js.map