"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArtifactoryServer = isArtifactoryServer;
exports.getGoogleAuthHostRule = getGoogleAuthHostRule;
exports.getGoogleAuthToken = getGoogleAuthToken;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const google_auth_library_1 = require("google-auth-library");
const logger_1 = require("../../logger");
const sanitize_1 = require("../../util/sanitize");
const JFROG_ARTIFACTORY_RES_HEADER = 'x-jfrog-version';
function isArtifactoryServer(res) {
    return is_1.default.string(res?.headers[JFROG_ARTIFACTORY_RES_HEADER]);
}
async function getGoogleAuthHostRule() {
    try {
        const googleAuth = new google_auth_library_1.GoogleAuth({
            scopes: 'https://www.googleapis.com/auth/cloud-platform',
        });
        const accessToken = await googleAuth.getAccessToken();
        if (accessToken) {
            // sanitize token
            (0, sanitize_1.addSecretForSanitizing)(accessToken);
            return {
                username: 'oauth2accesstoken',
                password: accessToken,
            };
        }
        else {
            logger_1.logger.warn('Could not retrieve access token using google-auth-library getAccessToken');
        }
    }
    catch (err) {
        if (err.message?.includes('Could not load the default credentials')) {
            return null;
        }
        else {
            throw err;
        }
    }
    return null;
}
async function getGoogleAuthToken() {
    const rule = await getGoogleAuthHostRule();
    if (rule) {
        const token = Buffer.from(`${rule.username}:${rule.password}`).toString('base64');
        (0, sanitize_1.addSecretForSanitizing)(token);
        return token;
    }
    return null;
}
//# sourceMappingURL=util.js.map