import { Datasource } from '../datasource';
import type { GetReleasesConfig, RegistryStrategy, ReleaseResult } from '../types';
export declare const SBT_PLUGINS_REPO = "https://repo.scala-sbt.org/scalasbt/sbt-plugin-releases";
export declare class SbtPluginDatasource extends Datasource {
    static readonly id = "sbt-plugin";
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "ivy";
    readonly registryStrategy: RegistryStrategy;
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `scm` tags in the results.";
    constructor();
    getArtifactSubdirs(searchRoot: string, artifact: string, scalaVersion: string): Promise<string[] | null>;
    getPackageReleases(searchRoot: string, artifactSubdirs: string[] | null): Promise<string[] | null>;
    getUrls(searchRoot: string, artifactDirs: string[] | null, version: string | null): Promise<Partial<ReleaseResult>>;
    resolvePluginReleases(rootUrl: string, artifact: string, scalaVersion: string): Promise<string[] | null>;
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
