"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPageLinks = extractPageLinks;
exports.getLatestVersion = getLatestVersion;
const array_1 = require("../../../util/array");
const filter_map_1 = require("../../../util/filter-map");
const compare_1 = require("../../versioning/maven/compare");
const linkRegExp = /(?<=href=['"])[^'"]*(?=\/['"])/gi;
function extractPageLinks(html, filterMapHref) {
    const unfiltered = (0, array_1.coerceArray)(html.match(linkRegExp));
    return (0, filter_map_1.filterMap)(unfiltered, filterMapHref);
}
function getLatestVersion(versions) {
    if (versions?.length) {
        return versions.reduce((latestVersion, version) => (0, compare_1.compare)(version, latestVersion) === 1 ? version : latestVersion);
    }
    return null;
}
//# sourceMappingURL=util.js.map