import type { Timestamp } from '../../../util/timestamp';
import { MavenDatasource } from '../maven';
import type { GetReleasesConfig, PostprocessReleaseConfig, PostprocessReleaseResult, RegistryStrategy, Release, ReleaseResult } from '../types';
interface ScalaDepCoordinate {
    groupId: string;
    artifactId: string;
    scalaVersion?: string;
}
interface PomInfo {
    homepage?: string;
    sourceUrl?: string;
    releaseTimestamp?: Timestamp;
}
export declare class SbtPackageDatasource extends MavenDatasource {
    static readonly id = "sbt-package";
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "ivy";
    readonly registryStrategy: RegistryStrategy;
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `scm` tags in the results.";
    constructor(id?: string);
    protected static parseDepCoordinate(packageName: string): ScalaDepCoordinate;
    getSbtReleases(registryUrl: string, packageName: string): Promise<ReleaseResult | null>;
    getPomInfo(registryUrl: string, packageName: string, version: string | null, pkgUrls?: string[]): Promise<PomInfo | null>;
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult | null>;
    postprocessRelease(config: PostprocessReleaseConfig, release: Release): Promise<PostprocessReleaseResult>;
}
export {};
