"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assignMetadata = assignMetadata;
exports.getV1Metadata = getV1Metadata;
exports.getV1Releases = getV1Releases;
const assign_keys_1 = require("../../../util/assign-keys");
const url_1 = require("../../../util/url");
const schema_1 = require("./schema");
function assignMetadata(releases, metadata) {
    return (0, assign_keys_1.assignKeys)(releases, metadata, [
        'changelogUrl',
        'sourceUrl',
        'homepage',
    ]);
}
function getV1Metadata(http, registryUrl, packageName) {
    const metadataUrl = (0, url_1.joinUrlParts)(registryUrl, '/api/v1/gems', `${packageName}.json`);
    return http.getJsonSafe(metadataUrl, schema_1.GemMetadata);
}
function getV1Releases(http, registryUrl, packageName) {
    const versionsUrl = (0, url_1.joinUrlParts)(registryUrl, '/api/v1/versions', `${packageName}.json`);
    return http.getJsonSafe(versionsUrl, schema_1.GemVersions).transform((releaseResult) => getV1Metadata(http, registryUrl, packageName)
        .transform((metadata) => assignMetadata(releaseResult, metadata))
        .unwrapOr(releaseResult));
}
//# sourceMappingURL=common.js.map