import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class RpmDatasource extends Datasource {
    static readonly id = "rpm";
    static readonly repomdXmlFileName = "repomd.xml";
    constructor();
    /**
     * Users are able to specify custom RPM repositories as long as they follow the format.
     * There is a URI http://linux.duke.edu/metadata/common in the <sha>-primary.xml.
     * But according to this post, it's not something we can really look into or reference.
     * @see{https://lists.rpm.org/pipermail/rpm-ecosystem/2015-October/000283.html}
     */
    readonly customRegistrySupport = true;
    /**
     * Fetches the release information for a given package from the registry URL.
     *
     * @param registryUrl - the registryUrl should be the folder which contains repodata.xml and its corresponding file list <sha256>-primary.xml.gz, e.g.: https://packages.microsoft.com/azurelinux/3.0/prod/cloud-native/x86_64/repodata/
     * @param packageName - the name of the package to fetch releases for.
     * @returns The release result if the package is found, otherwise null.
     */
    getReleases({ registryUrl, packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    getPrimaryGzipUrl(registryUrl: string): Promise<string | null>;
    getReleasesByPackageName(primaryGzipUrl: string, packageName: string): Promise<ReleaseResult | null>;
}
