import { z } from 'zod';
import type { Release } from '../types';
export declare const PythonRelease: z.ZodArray<z.ZodEffects<z.ZodObject<{
    /** e.g: "Python 3.9.0b1" */
    name: z.ZodString;
    /** e.g: "python-390b1" */
    slug: z.ZodString;
    /** Major version e.g: 3 */
    version: z.ZodNumber;
    /** is latest major version, true for Python 2.7.18 and latest Python 3 */
    is_latest: z.ZodBoolean;
    is_published: z.ZodBoolean;
    release_date: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
    pre_release: z.ZodBoolean;
    release_page: z.ZodNullable<z.ZodString>;
    show_on_download_page: z.ZodBoolean;
    /** Changelog e.g: "https://docs.python.org/…html#python-3-9-0-beta-1" */
    release_notes_url: z.ZodString;
    /** Download URL e.g: "https://www.python.org/api/v2/downloads/release/436/" */
    resource_uri: z.ZodString;
}, "strip", z.ZodTypeAny, {
    name: string;
    version: number;
    release_date: import("../../../util/timestamp").Timestamp | null;
    slug: string;
    is_latest: boolean;
    is_published: boolean;
    pre_release: boolean;
    release_page: string | null;
    show_on_download_page: boolean;
    release_notes_url: string;
    resource_uri: string;
}, {
    name: string;
    version: number;
    slug: string;
    is_latest: boolean;
    is_published: boolean;
    pre_release: boolean;
    release_page: string | null;
    show_on_download_page: boolean;
    release_notes_url: string;
    resource_uri: string;
    release_date?: unknown;
}>, Release, {
    name: string;
    version: number;
    slug: string;
    is_latest: boolean;
    is_published: boolean;
    pre_release: boolean;
    release_page: string | null;
    show_on_download_page: boolean;
    release_notes_url: string;
    resource_uri: string;
    release_date?: unknown;
}>, "many">;
