"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonVersionDatasource = void 0;
const tslib_1 = require("tslib");
const decorator_1 = require("../../../util/cache/package/decorator");
const python_1 = require("../../versioning/python");
const datasource_1 = require("../datasource");
const endoflife_date_1 = require("../endoflife-date");
const common_1 = require("../endoflife-date/common");
const github_releases_1 = require("../github-releases");
const common_2 = require("./common");
const schema_1 = require("./schema");
class PythonVersionDatasource extends datasource_1.Datasource {
    static id = common_2.datasource;
    pythonPrebuildDatasource;
    pythonEolDatasource;
    constructor() {
        super(common_2.datasource);
        this.pythonPrebuildDatasource = new github_releases_1.GithubReleasesDatasource();
        this.pythonEolDatasource = new endoflife_date_1.EndoflifeDateDatasource();
    }
    customRegistrySupport = false;
    defaultRegistryUrls = [common_2.defaultRegistryUrl];
    defaultVersioning = python_1.id;
    caching = true;
    async getPrebuildReleases() {
        return await this.pythonPrebuildDatasource.getReleases({
            registryUrl: common_2.githubBaseUrl,
            packageName: 'containerbase/python-prebuild',
        });
    }
    async getEolReleases() {
        return await this.pythonEolDatasource.getReleases({
            registryUrl: common_1.registryUrl,
            packageName: 'python',
        });
    }
    async getReleases({ registryUrl, }) {
        /* v8 ignore next 3 -- should never happen */
        if (!registryUrl) {
            return null;
        }
        const pythonPrebuildReleases = await this.getPrebuildReleases();
        const pythonPrebuildVersions = new Set(pythonPrebuildReleases?.releases.map((release) => release.version));
        const pythonEolReleases = await this.getEolReleases();
        const pythonEolVersions = new Map(pythonEolReleases?.releases
            .filter((release) => release.isDeprecated !== undefined)
            .map((release) => [
            release.version.split('.').slice(0, 2).join('.'),
            release.isDeprecated,
        ]));
        const result = {
            homepage: 'https://python.org',
            sourceUrl: 'https://github.com/python/cpython',
            registryUrl,
            releases: [],
        };
        try {
            const response = await this.http.getJson(registryUrl, schema_1.PythonRelease);
            result.releases.push(...response.body
                .filter((release) => release.isStable)
                .filter((release) => pythonPrebuildVersions.has(release.version)));
        }
        catch (err) {
            this.handleGenericErrors(err);
        }
        for (const release of result.releases) {
            release.isDeprecated = pythonEolVersions.get(release.version.split('.').slice(0, 2).join('.'));
        }
        return result.releases.length ? result : null;
    }
}
exports.PythonVersionDatasource = PythonVersionDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${common_2.datasource}`,
        key: ({ registryUrl }) => `${registryUrl}`,
    })
], PythonVersionDatasource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map