import { Datasource } from '../datasource';
import { EndoflifeDateDatasource } from '../endoflife-date';
import { GithubReleasesDatasource } from '../github-releases';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class PythonVersionDatasource extends Datasource {
    static readonly id = "python-version";
    pythonPrebuildDatasource: GithubReleasesDatasource;
    pythonEolDatasource: EndoflifeDateDatasource;
    constructor();
    readonly customRegistrySupport = false;
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "python";
    readonly caching = true;
    getPrebuildReleases(): Promise<ReleaseResult | null>;
    getEolReleases(): Promise<ReleaseResult | null>;
    getReleases({ registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
