import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class PypiDatasource extends Datasource {
    static readonly id = "pypi";
    constructor();
    readonly caching = true;
    readonly customRegistrySupport = true;
    static readonly defaultURL: string;
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "pep440";
    readonly registryStrategy = "merge";
    readonly releaseTimestampNote = "The relase timestamp is determined from the `upload_time` field in the results.";
    readonly sourceUrlSupport = "release";
    readonly sourceUrlNote = "The source URL is determined from the `homepage` field if it is a github repository, else we use the `project_urls` field.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    private getAuthHeaders;
    private getDependency;
    private static extractVersionFromLinkText;
    private static cleanSimpleHtml;
    private getSimpleDependency;
}
