"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isGitHubRepo = isGitHubRepo;
exports.normalizePythonDepName = normalizePythonDepName;
const regex_1 = require("../../../util/regex");
const githubRepoPattern = (0, regex_1.regEx)(/^https?:\/\/github\.com\/[^/]+\/[^/]+$/);
function isGitHubRepo(url) {
    return !url.includes('sponsors') && githubRepoPattern.test(url);
}
// https://packaging.python.org/en/latest/specifications/name-normalization/
function normalizePythonDepName(name) {
    return name.replace(/[-_.]+/g, '-').toLowerCase();
}
//# sourceMappingURL=common.js.map