import { Datasource } from '../datasource';
import type { GetReleasesConfig, Release, ReleaseResult } from '../types';
import type { PuppetModule } from './types';
export declare class PuppetForgeDatasource extends Datasource {
    static id: string;
    constructor();
    readonly defaultRegistryUrls: string[];
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `created_at` field from the response.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    static createReleaseResult(releases: Release[], module: PuppetModule): ReleaseResult;
}
