"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.postprocessRelease = postprocessRelease;
const logger_1 = require("../../logger");
const common_1 = require("./common");
const datasource_1 = require("./datasource");
async function postprocessRelease(config, release) {
    const { datasource } = config;
    const ds = datasource && (0, common_1.getDatasourceFor)(datasource);
    if (!ds) {
        logger_1.logger.once.warn({ datasource }, 'Failed to resolve datasource during release postprocessing');
        return release;
    }
    if (ds.constructor.prototype.postprocessRelease ===
        datasource_1.Datasource.prototype.postprocessRelease) {
        return release;
    }
    const { packageName } = config;
    if (!packageName) {
        logger_1.logger.once.warn({ datasource }, 'Release postprocessing is not supported for empty `packageName` field');
        return release;
    }
    const registryUrl = config.registryUrl ?? config.registryUrls?.at(0) ?? null;
    try {
        const result = await ds.postprocessRelease({ packageName, registryUrl }, release);
        if (result === 'reject') {
            logger_1.logger.debug({
                datasource,
                packageName,
                registryUrl,
                version: release.version,
                versionOrig: release.versionOrig,
            }, 'Rejected release');
            return null;
        }
        return result;
    }
    catch (err) {
        logger_1.logger.once.warn({ err }, `Release interceptor failed for "${datasource}"`);
        return release;
    }
}
//# sourceMappingURL=postprocess-release.js.map