import { z } from 'zod';
import type { ReleaseResult } from '../types';
export declare const MinifiedArray: z.ZodEffects<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnknown>, "many">, Record<string, unknown>[], Record<string, unknown>[]>;
export type MinifiedArray = z.infer<typeof MinifiedArray>;
export declare const ComposerRelease: z.ZodObject<{
    version: z.ZodUnion<[z.ZodString, z.ZodEffects<z.ZodNumber, string, number>]>;
    homepage: z.ZodCatch<z.ZodNullable<z.ZodString>>;
    source: z.ZodCatch<z.ZodNullable<z.ZodObject<{
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
    }, {
        url: string;
    }>>>;
    time: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
    require: z.ZodCatch<z.ZodNullable<z.ZodObject<{
        php: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        php: string;
    }, {
        php: string;
    }>>>;
}, "strip", z.ZodTypeAny, {
    time: import("../../../util/timestamp").Timestamp | null;
    version: string;
    homepage: string | null;
    source: {
        url: string;
    } | null;
    require: {
        php: string;
    } | null;
}, {
    version: string | number;
    time?: unknown;
    homepage?: unknown;
    source?: unknown;
    require?: unknown;
}>;
export type ComposerRelease = z.infer<typeof ComposerRelease>;
export declare const ComposerReleases: z.ZodCatch<z.ZodUnion<[z.ZodPipeline<z.ZodEffects<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnknown>, "many">, Record<string, unknown>[], Record<string, unknown>[]>, z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
    time: import("../../../util/timestamp").Timestamp | null;
    version: string;
    homepage: string | null;
    source: {
        url: string;
    } | null;
    require: {
        php: string;
    } | null;
}[], any[]>>, z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
    time: import("../../../util/timestamp").Timestamp | null;
    version: string;
    homepage: string | null;
    source: {
        url: string;
    } | null;
    require: {
        php: string;
    } | null;
}>, Record<string, any>>, {
    time: import("../../../util/timestamp").Timestamp | null;
    version: string;
    homepage: string | null;
    source: {
        url: string;
    } | null;
    require: {
        php: string;
    } | null;
}[], Record<string, any>>]>>;
export type ComposerReleases = z.infer<typeof ComposerReleases>;
export declare const ComposerPackagesResponse: z.ZodEffects<z.ZodEffects<z.ZodObject<{
    packageName: z.ZodString;
    packagesResponse: z.ZodObject<{
        packages: z.ZodRecord<z.ZodString, z.ZodUnknown>;
    }, "strip", z.ZodTypeAny, {
        packages: Record<string, unknown>;
    }, {
        packages: Record<string, unknown>;
    }>;
}, "strip", z.ZodTypeAny, {
    packageName: string;
    packagesResponse: {
        packages: Record<string, unknown>;
    };
}, {
    packageName: string;
    packagesResponse: {
        packages: Record<string, unknown>;
    };
}>, unknown, {
    packageName: string;
    packagesResponse: {
        packages: Record<string, unknown>;
    };
}>, {
    time: import("../../../util/timestamp").Timestamp | null;
    version: string;
    homepage: string | null;
    source: {
        url: string;
    } | null;
    require: {
        php: string;
    } | null;
}[], {
    packageName: string;
    packagesResponse: {
        packages: Record<string, unknown>;
    };
}>;
export type ComposerPackagesResponse = z.infer<typeof ComposerPackagesResponse>;
export declare function parsePackagesResponse(packageName: string, packagesResponse: unknown): ComposerReleases;
export declare function extractReleaseResult(...composerReleasesArrays: ComposerReleases[]): ReleaseResult | null;
export declare function extractDepReleases(composerReleases: unknown): ReleaseResult | null;
export declare function parsePackagesResponses(packageName: string, packagesResponses: unknown[]): ReleaseResult | null;
export declare const HashSpec: z.ZodUnion<[z.ZodEffects<z.ZodObject<{
    sha256: z.ZodNullable<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    sha256: string | null;
}, {
    sha256: string | null;
}>, {
    hash: string | null;
}, {
    sha256: string | null;
}>, z.ZodEffects<z.ZodObject<{
    sha1: z.ZodNullable<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    sha1: string | null;
}, {
    sha1: string | null;
}>, {
    hash: string | null;
}, {
    sha1: string | null;
}>]>;
export type HashSpec = z.infer<typeof HashSpec>;
export declare const RegistryFile: z.ZodIntersection<z.ZodUnion<[z.ZodEffects<z.ZodObject<{
    sha256: z.ZodNullable<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    sha256: string | null;
}, {
    sha256: string | null;
}>, {
    hash: string | null;
}, {
    sha256: string | null;
}>, z.ZodEffects<z.ZodObject<{
    sha1: z.ZodNullable<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    sha1: string | null;
}, {
    sha1: string | null;
}>, {
    hash: string | null;
}, {
    sha1: string | null;
}>]>, z.ZodObject<{
    key: z.ZodString;
}, "strip", z.ZodTypeAny, {
    key: string;
}, {
    key: string;
}>>;
export type RegistryFile = z.infer<typeof RegistryFile>;
export declare const PackagesResponse: z.ZodObject<{
    packages: z.ZodCatch<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        time: import("../../../util/timestamp").Timestamp | null;
        version: string;
        homepage: string | null;
        source: {
            url: string;
        } | null;
        require: {
            php: string;
        } | null;
    }[]>, Record<string, any>>>;
}, "strip", z.ZodTypeAny, {
    packages: Record<string, {
        time: import("../../../util/timestamp").Timestamp | null;
        version: string;
        homepage: string | null;
        source: {
            url: string;
        } | null;
        require: {
            php: string;
        } | null;
    }[]>;
}, {
    packages?: unknown;
}>;
export type PackagesResponse = z.infer<typeof PackagesResponse>;
export declare const PackagistFile: z.ZodObject<{
    packages: z.ZodCatch<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        time: import("../../../util/timestamp").Timestamp | null;
        version: string;
        homepage: string | null;
        source: {
            url: string;
        } | null;
        require: {
            php: string;
        } | null;
    }[]>, Record<string, any>>>;
} & {
    providers: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        hash: string | null;
    } | {
        hash: string | null;
    }>, Record<string, any>>, {
        [k: string]: string | null;
    }, Record<string, any>>>;
}, "strip", z.ZodTypeAny, {
    packages: Record<string, {
        time: import("../../../util/timestamp").Timestamp | null;
        version: string;
        homepage: string | null;
        source: {
            url: string;
        } | null;
        require: {
            php: string;
        } | null;
    }[]>;
    providers: {
        [k: string]: string | null;
    };
}, {
    packages?: unknown;
    providers?: unknown;
}>;
export type PackagistFile = z.infer<typeof PackagistFile>;
export declare const RegistryMeta: z.ZodEffects<z.ZodPipeline<z.ZodCatch<z.ZodRecord<z.ZodString, z.ZodUnknown>>, z.ZodObject<{
    packages: z.ZodCatch<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        time: import("../../../util/timestamp").Timestamp | null;
        version: string;
        homepage: string | null;
        source: {
            url: string;
        } | null;
        require: {
            php: string;
        } | null;
    }[]>, Record<string, any>>>;
} & {
    providers: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        hash: string | null;
    } | {
        hash: string | null;
    }>, Record<string, any>>, {
        [k: string]: string | null;
    }, Record<string, any>>>;
} & {
    includes: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        hash: string | null;
    } | {
        hash: string | null;
    }>, Record<string, any>>, {
        key: string;
        hash: string | null;
    }[], Record<string, any>>>;
    "provider-includes": z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        hash: string | null;
    } | {
        hash: string | null;
    }>, Record<string, any>>, {
        key: string;
        hash: string | null;
    }[], Record<string, any>>>;
    "providers-lazy-url": z.ZodCatch<z.ZodNullable<z.ZodString>>;
    "providers-url": z.ZodCatch<z.ZodNullable<z.ZodString>>;
    "metadata-url": z.ZodCatch<z.ZodNullable<z.ZodString>>;
    "available-packages": z.ZodCatch<z.ZodNullable<z.ZodArray<z.ZodString, "many">>>;
}, "strip", z.ZodTypeAny, {
    includes: {
        key: string;
        hash: string | null;
    }[];
    packages: Record<string, {
        time: import("../../../util/timestamp").Timestamp | null;
        version: string;
        homepage: string | null;
        source: {
            url: string;
        } | null;
        require: {
            php: string;
        } | null;
    }[]>;
    providers: {
        [k: string]: string | null;
    };
    "provider-includes": {
        key: string;
        hash: string | null;
    }[];
    "providers-lazy-url": string | null;
    "providers-url": string | null;
    "metadata-url": string | null;
    "available-packages": string[] | null;
}, {
    includes?: unknown;
    packages?: unknown;
    providers?: unknown;
    "provider-includes"?: unknown;
    "providers-lazy-url"?: unknown;
    "providers-url"?: unknown;
    "metadata-url"?: unknown;
    "available-packages"?: unknown;
}>>, {
    packages: Record<string, {
        time: import("../../../util/timestamp").Timestamp | null;
        version: string;
        homepage: string | null;
        source: {
            url: string;
        } | null;
        require: {
            php: string;
        } | null;
    }[]>;
    includesFiles: {
        key: string;
        hash: string | null;
    }[];
    providerPackages: {
        [k: string]: string | null;
    };
    files: {
        key: string;
        hash: string | null;
    }[];
    providersUrl: string | null;
    providersLazyUrl: string | null;
    metadataUrl: string | null;
    includesPackages: Record<string, ReleaseResult | null>;
    availablePackages: string[] | null;
}, unknown>;
export type RegistryMeta = z.infer<typeof RegistryMeta>;
