import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
import type { RegistryFile } from './schema';
import { PackagistFile, RegistryMeta } from './schema';
export declare class PackagistDatasource extends Datasource {
    static readonly id = "packagist";
    constructor();
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "composer";
    readonly registryStrategy = "hunt";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `time` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from `source` field in the results.";
    private static getHostOpts;
    private getJson;
    getRegistryMeta(regUrl: string): Promise<RegistryMeta>;
    private static isPrivatePackage;
    private static getPackagistFileUrl;
    getPackagistFile(regUrl: string, regFile: RegistryFile): Promise<PackagistFile>;
    fetchProviderPackages(regUrl: string, meta: RegistryMeta): Promise<void>;
    fetchIncludesPackages(regUrl: string, meta: RegistryMeta): Promise<void>;
    packagistV2Lookup(registryUrl: string, metadataUrl: string, packageName: string): Promise<ReleaseResult | null>;
    getPkgUrl(packageName: string, registryUrl: string, registryMeta: RegistryMeta): string | null;
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
