import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class OrbDatasource extends Datasource {
    static readonly id = "orb";
    constructor();
    readonly customRegistrySupport = true;
    readonly defaultRegistryUrls: string[];
    readonly registryStrategy = "hunt";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `createdAt` field in the results.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
