"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NugetDatasource = exports.nugetOrg = void 0;
const tslib_1 = require("tslib");
const logger_1 = require("../../../logger");
const nugetVersioning = tslib_1.__importStar(require("../../versioning/nuget"));
const datasource_1 = require("../datasource");
const common_1 = require("./common");
const v2_1 = require("./v2");
const v3_1 = require("./v3");
// https://api.nuget.org/v3/index.json is a default official nuget feed
exports.nugetOrg = 'https://api.nuget.org/v3/index.json';
class NugetDatasource extends datasource_1.Datasource {
    static id = 'nuget';
    defaultRegistryUrls = [exports.nugetOrg];
    defaultVersioning = nugetVersioning.id;
    registryStrategy = 'merge';
    releaseTimestampSupport = true;
    releaseTimestampNote = 'For the v2 API, the release timestamp is determined from the `Published` tag. And, for the v3 API, the release timestamp is determined from the `published` field in the results.';
    sourceUrlSupport = 'package';
    sourceUrlNote = 'For the v2 API, the source URL is determined from the `ProjectUrl` tag. And, for the v3 API, the source URL is determined from the `metadata.repository@url` field in the results.';
    v2Api = new v2_1.NugetV2Api();
    v3Api = new v3_1.NugetV3Api();
    constructor() {
        super(NugetDatasource.id);
    }
    async getReleases({ packageName, registryUrl, }) {
        logger_1.logger.trace(`nuget.getReleases(${packageName})`);
        /* v8 ignore next 3 -- should never happen */
        if (!registryUrl) {
            return null;
        }
        const { feedUrl, protocolVersion } = (0, common_1.parseRegistryUrl)(registryUrl);
        if (protocolVersion === 2) {
            return this.v2Api.getReleases(this.http, feedUrl, packageName);
        }
        if (protocolVersion === 3) {
            const queryUrl = await this.v3Api.getResourceUrl(this.http, feedUrl);
            if (queryUrl) {
                return this.v3Api.getReleases(this.http, feedUrl, queryUrl, packageName);
            }
        }
        return null;
    }
}
exports.NugetDatasource = NugetDatasource;
//# sourceMappingURL=index.js.map