import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
import { NugetV2Api } from './v2';
import { NugetV3Api } from './v3';
export declare const nugetOrg = "https://api.nuget.org/v3/index.json";
export declare class NugetDatasource extends Datasource {
    static readonly id = "nuget";
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "nuget";
    readonly registryStrategy = "merge";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "For the v2 API, the release timestamp is determined from the `Published` tag. And, for the v3 API, the release timestamp is determined from the `published` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "For the v2 API, the source URL is determined from the `ProjectUrl` tag. And, for the v3 API, the source URL is determined from the `metadata.repository@url` field in the results.";
    readonly v2Api: NugetV2Api;
    readonly v3Api: NugetV3Api;
    constructor();
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
