"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeVersionDatasource = void 0;
const tslib_1 = require("tslib");
const decorator_1 = require("../../../util/cache/package/decorator");
const timestamp_1 = require("../../../util/timestamp");
const url_1 = require("../../../util/url");
const node_1 = require("../../versioning/node");
const datasource_1 = require("../datasource");
const common_1 = require("./common");
class NodeVersionDatasource extends datasource_1.Datasource {
    static id = common_1.datasource;
    constructor() {
        super(common_1.datasource);
    }
    defaultRegistryUrls = [common_1.defaultRegistryUrl];
    defaultVersioning = node_1.id;
    caching = true;
    releaseTimestampSupport = true;
    releaseTimestampNote = 'The release timestamp is determined from the `date` field.';
    sourceUrlSupport = 'package';
    sourceUrlNote = 'We use the URL: https://github.com/nodejs/node';
    async getReleases({ registryUrl, }) {
        /* v8 ignore next 3 -- should never happen */
        if (!registryUrl) {
            return null;
        }
        const result = {
            homepage: 'https://nodejs.org',
            sourceUrl: 'https://github.com/nodejs/node',
            registryUrl,
            releases: [],
        };
        try {
            const resp = (await this.http.getJsonUnchecked((0, url_1.joinUrlParts)(registryUrl, 'index.json'))).body;
            result.releases.push(...resp.map(({ version, date, lts }) => ({
                version,
                releaseTimestamp: (0, timestamp_1.asTimestamp)(date),
                isStable: lts !== false,
            })));
        }
        catch (err) {
            this.handleGenericErrors(err);
        }
        return result.releases.length ? result : null;
    }
}
exports.NodeVersionDatasource = NodeVersionDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${common_1.datasource}`,
        // TODO: types (#22198)
        key: ({ registryUrl }) => `${registryUrl}`,
    })
], NodeVersionDatasource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map