import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class NodeVersionDatasource extends Datasource {
    static readonly id = "node-version";
    constructor();
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "node";
    readonly caching = true;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `date` field.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "We use the URL: https://github.com/nodejs/node";
    getReleases({ registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
