import type { ReleaseResult } from './types';
export declare function massageUrl(sourceUrl: string): string;
export declare function massageGithubUrl(url: string): string;
export declare function addMetaData(dep: ReleaseResult, datasource: string, packageName: string): void;
/**
 * Returns true if
 * 1. it's a github or gitlab url and not a path within the repo.
 * 2. it's equal to sourceURl
 * @param sourceUrl
 * @param homepage
 */
export declare function shouldDeleteHomepage(sourceUrl: string | null | undefined, homepage: string | undefined): boolean;
