import { XmlDocument } from 'xmldoc';
import { type Http } from '../../../util/http';
import type { HttpOptions } from '../../../util/http/types';
import type { DependencyInfo, MavenDependency, MavenFetchResult } from './types';
export declare function downloadHttpProtocol(http: Http, pkgUrl: URL | string, opts?: HttpOptions): Promise<MavenFetchResult>;
export declare function downloadHttpContent(http: Http, pkgUrl: URL | string, opts?: HttpOptions): Promise<string | null>;
export declare function downloadS3Protocol(pkgUrl: URL): Promise<MavenFetchResult>;
export declare function downloadArtifactRegistryProtocol(http: Http, pkgUrl: URL): Promise<MavenFetchResult>;
export declare function getMavenUrl(dependency: MavenDependency, repoUrl: string, path: string): URL;
export declare function downloadMaven(http: Http, url: URL): Promise<MavenFetchResult>;
export declare function downloadMavenXml(http: Http, url: URL): Promise<MavenFetchResult<XmlDocument>>;
export declare function getDependencyParts(packageName: string): MavenDependency;
export declare function createUrlForDependencyPom(http: Http, version: string, dependency: MavenDependency, repoUrl: string): Promise<string>;
export declare function getDependencyInfo(http: Http, dependency: MavenDependency, repoUrl: string, version: string, recursionLimit?: number): Promise<DependencyInfo>;
