import { Datasource } from '../datasource';
import type { GetReleasesConfig, PostprocessReleaseConfig, PostprocessReleaseResult, RegistryStrategy, Release, ReleaseResult } from '../types';
import type { MavenDependency, MetadataResults } from './types';
export declare const defaultRegistryUrls: string[];
export declare class MavenDatasource extends Datasource {
    static id: string;
    readonly caching = true;
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning: string;
    readonly registryStrategy: RegistryStrategy;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `Last-Modified` header or the `lastModified` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `scm` tags in the results.";
    constructor(id?: string);
    fetchVersionsFromMetadata(dependency: MavenDependency, repoUrl: string): Promise<MetadataResults>;
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    postprocessRelease({ packageName, registryUrl }: PostprocessReleaseConfig, release: Release): Promise<PostprocessReleaseResult>;
}
