"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesApiDatasource = exports.supportedApis = void 0;
const tslib_1 = require("tslib");
const json5_1 = tslib_1.__importDefault(require("json5"));
const data_files_generated_1 = tslib_1.__importDefault(require("../../../data-files.generated"));
const kubernetesApiVersioning = tslib_1.__importStar(require("../../versioning/kubernetes-api"));
const datasource_1 = require("../datasource");
const apiData = json5_1.default.parse(data_files_generated_1.default.get('data/kubernetes-api.json5'));
exports.supportedApis = new Set(Object.keys(apiData));
class KubernetesApiDatasource extends datasource_1.Datasource {
    static id = 'kubernetes-api';
    constructor() {
        super(KubernetesApiDatasource.id);
    }
    defaultVersioning = kubernetesApiVersioning.id;
    getReleases({ packageName, }) {
        const versions = apiData[packageName];
        if (versions) {
            const releases = versions.map((version) => ({ version }));
            return Promise.resolve({ releases });
        }
        return Promise.resolve(null);
    }
}
exports.KubernetesApiDatasource = KubernetesApiDatasource;
//# sourceMappingURL=index.js.map