import { Datasource } from '../datasource';
import type { GetReleasesConfig, Release, ReleaseResult } from '../types';
export declare class JenkinsPluginsDatasource extends Datasource {
    static readonly id = "jenkins-plugins";
    constructor();
    readonly customRegistrySupport = true;
    readonly defaultRegistryUrls: string[];
    readonly registryStrategy = "hunt";
    private static readonly packageInfoPath;
    private static readonly packageVersionsPath;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The releaseTimestamp is determined from the `releaseTimestamp` or `buildDate` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `scm` field in the results.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    getJenkinsPluginInfo(updateSiteUrl: string): Promise<Record<string, ReleaseResult>>;
    getJenkinsPluginVersions(updateSiteUrl: string): Promise<Record<string, Release[]>>;
    private getJenkinsUpdateCenterResponse;
}
