"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavaVersionDatasource = void 0;
const tslib_1 = require("tslib");
const logger_1 = require("../../../logger");
const external_host_error_1 = require("../../../types/errors/external-host-error");
const decorator_1 = require("../../../util/cache/package/decorator");
const http_1 = require("../../../util/http");
const datasource_1 = require("../datasource");
const common_1 = require("./common");
class JavaVersionDatasource extends datasource_1.Datasource {
    static id = common_1.datasource;
    constructor() {
        super(common_1.datasource);
    }
    customRegistrySupport = false;
    defaultRegistryUrls = [common_1.defaultRegistryUrl];
    caching = true;
    async getPageReleases(url, page) {
        const pgUrl = `${url}&page=${page}`;
        try {
            const pgRes = await this.http.getJsonUnchecked(pgUrl);
            return (pgRes?.body?.versions?.map(({ semver }) => ({
                version: semver,
            })) ?? null);
        }
        catch (err) {
            if (page !== 0 &&
                err instanceof http_1.HttpError &&
                err.response?.statusCode === 404) {
                // No more pages
                return null;
            }
            throw err;
        }
    }
    async getReleases({ registryUrl, packageName, }) {
        const imageType = (0, common_1.getImageType)(packageName);
        logger_1.logger.trace({ registryUrl, packageName, imageType }, 'fetching java release');
        // TODO: types (#22198)
        const url = `${registryUrl}v3/info/release_versions?page_size=${common_1.pageSize}&image_type=${imageType}&project=jdk&release_type=ga&sort_method=DATE&sort_order=DESC`;
        const result = {
            homepage: 'https://adoptium.net',
            releases: [],
        };
        try {
            let page = 0;
            let releases = await this.getPageReleases(url, page);
            while (releases) {
                result.releases.push(...releases);
                if (releases.length !== common_1.pageSize || page >= 50) {
                    break;
                }
                page += 1;
                releases = await this.getPageReleases(url, page);
            }
        }
        catch (err) {
            if (err instanceof http_1.HttpError) {
                if (err.response?.statusCode !== 404) {
                    throw new external_host_error_1.ExternalHostError(err);
                }
            }
            this.handleGenericErrors(err);
        }
        return result.releases.length ? result : null;
    }
}
exports.JavaVersionDatasource = JavaVersionDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${common_1.datasource}`,
        key: ({ registryUrl, packageName }) => 
        // TODO: types (#22198)
        `${registryUrl}:${(0, common_1.getImageType)(packageName)}`,
    })
], JavaVersionDatasource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map