import { AsyncResult } from '../../util/result';
import type { DatasourceApi, GetDigestInputConfig, GetPkgReleasesConfig, ReleaseResult } from './types';
export * from './types';
export { isGetPkgReleasesConfig } from './common';
export declare const getDatasources: () => Map<string, DatasourceApi>;
export declare const getDatasourceList: () => string[];
export declare function getRawPkgReleases(config: GetPkgReleasesConfig): AsyncResult<ReleaseResult, Error | 'no-datasource' | 'no-package-name' | 'no-result'>;
export declare function applyDatasourceFilters(releaseResult: ReleaseResult, config: GetPkgReleasesConfig): ReleaseResult;
export declare function getPkgReleases(config: GetPkgReleasesConfig): Promise<ReleaseResult | null>;
export declare function supportsDigests(datasource: string | undefined): boolean;
export declare function getDigest(config: GetDigestInputConfig, value?: string): Promise<string | null>;
export declare function getDefaultConfig(datasource: string): Promise<Record<string, unknown>>;
