import { z } from 'zod';
import type { ReleaseResult } from '../types';
export declare const HexRelease: z.ZodEffects<z.ZodObject<{
    html_url: z.ZodOptional<z.ZodString>;
    meta: z.ZodCatch<z.ZodNullable<z.ZodObject<{
        links: z.ZodPipeline<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodString>, {
            [k: string]: string;
        }, Record<string, string>>, z.ZodObject<{
            github: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            github: string;
        }, {
            github: string;
        }>>;
    }, "strip", z.ZodTypeAny, {
        links: {
            github: string;
        };
    }, {
        links: Record<string, string>;
    }>>>;
    releases: z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        version: string;
        inserted_at: import("../../../util/timestamp").Timestamp | null;
    }[], any[]>, {
        version: string;
        inserted_at: import("../../../util/timestamp").Timestamp | null;
    }[], any[]>;
    retirements: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        message: z.ZodNullable<z.ZodString>;
        reason: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        message: string | null;
        reason: string;
    }, {
        message: string | null;
        reason: string;
    }>>>;
}, "strip", z.ZodTypeAny, {
    releases: {
        version: string;
        inserted_at: import("../../../util/timestamp").Timestamp | null;
    }[];
    meta: {
        links: {
            github: string;
        };
    } | null;
    html_url?: string | undefined;
    retirements?: Record<string, {
        message: string | null;
        reason: string;
    }> | undefined;
}, {
    releases: any[];
    html_url?: string | undefined;
    meta?: unknown;
    retirements?: Record<string, {
        message: string | null;
        reason: string;
    }> | undefined;
}>, ReleaseResult, {
    releases: any[];
    html_url?: string | undefined;
    meta?: unknown;
    retirements?: Record<string, {
        message: string | null;
        reason: string;
    }> | undefined;
}>;
