import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class HexDatasource extends Datasource {
    static readonly id = "hex";
    constructor();
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "hex";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined the `inserted_at` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `Github` field in the results.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
