import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
import type { HermitSearchResult } from './types';
/**
 * Hermit Datasource searches a given package from the specified `hermit-packages`
 * repository. It expects the search manifest to come from an asset `index.json` from
 * a release named index.
 */
export declare class HermitDatasource extends Datasource {
    static readonly id = "hermit";
    readonly customRegistrySupport = true;
    readonly registryStrategy = "first";
    readonly defaultVersioning = "hermit";
    readonly defaultRegistryUrls: string[];
    readonly sourceUrlSupport = "release";
    readonly sourceUrlNote = "The source URL is determined from the `Repository` field in the results.";
    pathRegex: RegExp;
    constructor();
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    /**
     * getHermitSearchManifest fetch the index.json from release
     * named index, parses it and returned the parsed JSON result
     */
    getHermitSearchManifest(u: URL): Promise<HermitSearchResult[] | null>;
}
