"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmDatasource = void 0;
const tslib_1 = require("tslib");
const logger_1 = require("../../../logger");
const decorator_1 = require("../../../util/cache/package/decorator");
const url_1 = require("../../../util/url");
const helmVersioning = tslib_1.__importStar(require("../../versioning/helm"));
const datasource_1 = require("../datasource");
const schema_1 = require("./schema");
class HelmDatasource extends datasource_1.Datasource {
    static id = 'helm';
    constructor() {
        super(HelmDatasource.id);
    }
    defaultRegistryUrls = ['https://charts.helm.sh/stable'];
    defaultConfig = {
        commitMessageTopic: 'Helm release {{depName}}',
    };
    defaultVersioning = helmVersioning.id;
    releaseTimestampSupport = true;
    releaseTimestampNote = 'The release timstamp is determined from the `created` field in the results.';
    sourceUrlSupport = 'package';
    sourceUrlNote = 'The source URL is determined from the `home` field or the `sources` field in the results.';
    async getRepositoryData(helmRepository) {
        const { val, err } = await this.http
            .getYamlSafe('index.yaml', { baseUrl: (0, url_1.ensureTrailingSlash)(helmRepository) }, schema_1.HelmRepositorySchema)
            .unwrap();
        if (err) {
            this.handleGenericErrors(err);
        }
        return val;
    }
    async getReleases({ packageName, registryUrl: helmRepository, }) {
        /* v8 ignore next 3 -- should never happen */
        if (!helmRepository) {
            return null;
        }
        const repositoryData = await this.getRepositoryData(helmRepository);
        const releases = repositoryData[packageName];
        if (!releases) {
            logger_1.logger.debug({ dependency: packageName }, `Entry ${packageName} doesn't exist in index.yaml from ${helmRepository}`);
            return null;
        }
        return releases;
    }
}
exports.HelmDatasource = HelmDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${HelmDatasource.id}`,
        key: (helmRepository) => `repository-data:${helmRepository}`,
    })
], HelmDatasource.prototype, "getRepositoryData", null);
//# sourceMappingURL=index.js.map