import { Datasource } from '../datasource';
import type { GetReleasesConfig, Release, ReleaseResult } from '../types';
export declare class HackageDatasource extends Datasource {
    static readonly id = "hackage";
    constructor();
    readonly defaultVersioning = "pvp";
    readonly customRegistrySupport = false;
    readonly defaultRegistryUrls: string[];
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult | null>;
}
export declare function versionToRelease(version: string, packageName: string, registryUrl: string, isDeprecated: boolean): Release;
