"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSourceUrl = getSourceUrl;
const url_1 = require("../../../util/github/url");
const bitbucket_tags_1 = require("../bitbucket-tags");
const github_tags_1 = require("../github-tags");
const gitlab_tags_1 = require("../gitlab-tags");
const util_1 = require("../gitlab-tags/util");
function getSourceUrl(dataSource) {
    if (dataSource) {
        const { datasource, registryUrl, packageName } = dataSource;
        if (datasource === github_tags_1.GithubTagsDatasource.id) {
            return (0, url_1.getSourceUrl)(packageName, registryUrl);
        }
        if (datasource === gitlab_tags_1.GitlabTagsDatasource.id) {
            return (0, util_1.getSourceUrl)(packageName, registryUrl);
        }
        if (datasource === bitbucket_tags_1.BitbucketTagsDatasource.id) {
            return bitbucket_tags_1.BitbucketTagsDatasource.getSourceUrl(packageName, registryUrl);
        }
    }
    // istanbul ignore next
    return undefined;
}
//# sourceMappingURL=common.js.map