import { GitlabHttp } from '../../../util/http/gitlab';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare class GitlabTagsDatasource extends Datasource {
    static readonly id = "gitlab-tags";
    protected http: GitlabHttp;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "To get release timestamp we use the `created_at` field from the response.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined by using the `packageName` and `registryUrl`.";
    constructor();
    readonly defaultRegistryUrls: string[];
    getReleases({ registryUrl, packageName: repo, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    /**
     * gitlab.getDigest
     *
     * Returs the latest commit hash of the repository.
     */
    getDigest({ packageName: repo, registryUrl }: DigestConfig, newValue?: string): Promise<string | null>;
}
