import { GitlabHttp } from '../../../util/http/gitlab';
import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class GitlabPackagesDatasource extends Datasource {
    static readonly id = "gitlab-packages";
    protected http: GitlabHttp;
    caching: boolean;
    customRegistrySupport: boolean;
    defaultRegistryUrls: string[];
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `created_at` field in the results.";
    constructor();
    static getGitlabPackageApiUrl(registryUrl: string, projectName: string, packageName: string): string;
    getReleases({ registryUrl, packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
