import { GithubHttp } from '../../../util/http/github';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare class GithubTagsDatasource extends Datasource {
    static readonly id = "github-tags";
    readonly defaultRegistryUrls: string[];
    readonly registryStrategy = "hunt";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The get release timestamp is determined from the `releaseTimestamp` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined by using the `packageName` and `registryUrl`.";
    http: GithubHttp;
    constructor();
    getCommit(registryUrl: string | undefined, githubRepo: string): Promise<string | null>;
    /**
     * github.getDigest
     *
     * The `newValue` supplied here should be a valid tag for the docker image.
     *
     * Returns the latest commit hash for the repository.
     */
    getDigest({ packageName: repo, registryUrl }: Partial<DigestConfig>, newValue?: string): Promise<string | null>;
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult>;
}
