import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class GithubRunnersDatasource extends Datasource {
    static readonly id = "github-runners";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "We use the URL: https://github.com/actions/runner-images.";
    /**
     * Unstable runners must have the `isStable: false` property.
     * Deprecated runners must have the `isDeprecated: true` property.
     * Stable runners should have no extra properties.
     * For more details, read the github-runners datasource readme.
     * Check https://github.blog/changelog/label/actions/ for stable and deprecation dates.
     */
    private static readonly releases;
    static isValidRunner(runnerName: string, runnerVersion: string): boolean;
    readonly defaultVersioning = "docker";
    constructor();
    getReleases({ packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
