import type { GithubDigestFile, GithubRestAsset, GithubRestRelease } from '../../../util/github/types';
import { GithubHttp } from '../../../util/http/github';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare const cacheNamespace = "datasource-github-releases";
export declare class GithubReleaseAttachmentsDatasource extends Datasource {
    static readonly id = "github-release-attachments";
    readonly defaultRegistryUrls: string[];
    http: GithubHttp;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `releaseTimestamp` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined by using the `packageName` and `registryUrl`.";
    constructor();
    findDigestFile(release: GithubRestRelease, digest: string): Promise<GithubDigestFile | null>;
    downloadAndDigest(asset: GithubRestAsset, algorithm: string): Promise<string>;
    findAssetWithDigest(release: GithubRestRelease, digest: string): Promise<GithubDigestFile | null>;
    /** Identify the asset associated with a known digest. */
    findDigestAsset(release: GithubRestRelease, digest: string): Promise<GithubDigestFile | null>;
    /** Given a digest asset, find the equivalent digest in a different release. */
    mapDigestAssetToRelease(digestAsset: GithubDigestFile, release: GithubRestRelease): Promise<string | null>;
    /**
     * Attempts to resolve the digest for the specified package.
     *
     * The `newValue` supplied here should be a valid tag for the GitHub release.
     * Requires `currentValue` and `currentDigest`.
     *
     * There may be many assets attached to the release. This function will:
     *  - Identify the asset pinned by `currentDigest` in the `currentValue` release
     *     - Download small release assets, parse as checksum manifests (e.g. `SHASUMS.txt`).
     *     - Download individual assets until `currentDigest` is encountered. This is limited to sha256 and sha512.
     *  - Map the hashed asset to `newValue` and return the updated digest as a string
     */
    getDigest({ packageName: repo, currentValue, currentDigest, registryUrl, }: DigestConfig, newValue: string): Promise<string | null>;
    /**
     * This function can be used to fetch releases with a customizable versioning
     * (e.g. semver) and with releases.
     *
     * This function will:
     *  - Fetch all releases
     *  - Sanitize the versions if desired (e.g. strip out leading 'v')
     *  - Return a dependency object containing sourceUrl string and releases array
     */
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult>;
}
