import { GiteaHttp } from '../../../util/http/gitea';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare class GiteaTagsDatasource extends Datasource {
    static readonly id = "gitea-tags";
    http: GiteaHttp;
    static readonly defaultRegistryUrls: string[];
    private static readonly cacheNamespace;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `created` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined by using the `packageName` and `registryUrl`.";
    constructor();
    static getRegistryURL(registryUrl?: string): string;
    static getApiUrl(registryUrl?: string): string;
    static getCacheKey(registryUrl: string | undefined, repo: string, type: string): string;
    static getSourceUrl(packageName: string, registryUrl?: string): string;
    getReleases({ registryUrl, packageName: repo, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    getTagCommit(registryUrl: string | undefined, repo: string, tag: string): Promise<string | null>;
    getDigest({ packageName: repo, registryUrl }: DigestConfig, newValue?: string): Promise<string | null>;
}
