import { GiteaHttp } from '../../../util/http/gitea';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare class GiteaReleasesDatasource extends Datasource {
    static readonly id = "gitea-releases";
    http: GiteaHttp;
    static readonly defaultRegistryUrls: string[];
    private static readonly cacheNamespace;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `published_at` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined by using the `packageName` and `registryUrl`.";
    constructor();
    getReleases({ registryUrl, packageName: repo, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    getTagCommit(registryUrl: string | undefined, repo: string, tag: string): Promise<string | null>;
    getDigest({ packageName: repo, registryUrl }: DigestConfig, newValue?: string): Promise<string | null>;
}
