import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
import { GitDatasource } from './base';
export declare class GitRefsDatasource extends GitDatasource {
    static readonly id = "git-refs";
    constructor();
    readonly customRegistrySupport = false;
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined by using the `packageName` and `registryUrl`.";
    getReleases({ packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    getDigest({ packageName }: DigestConfig, newValue?: string): Promise<string | null>;
}
