"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitDatasource = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const simple_git_1 = require("simple-git");
const logger_1 = require("../../../logger");
const decorator_1 = require("../../../util/cache/package/decorator");
const utils_1 = require("../../../util/exec/utils");
const auth_1 = require("../../../util/git/auth");
const config_1 = require("../../../util/git/config");
const url_1 = require("../../../util/git/url");
const regex_1 = require("../../../util/regex");
const datasource_1 = require("../datasource");
const refMatch = (0, regex_1.regEx)(/(?<hash>.*?)\s+refs\/(?<type>.*?)\/(?<value>.*)/);
const headMatch = (0, regex_1.regEx)(/(?<hash>.*?)\s+HEAD/);
const gitId = 'git';
// TODO: extract to a separate directory structure (#10532)
class GitDatasource extends datasource_1.Datasource {
    static id = gitId;
    constructor(id) {
        super(id);
    }
    async getRawRefs({ packageName, }) {
        const gitSubmoduleAuthEnvironmentVariables = (0, auth_1.getGitEnvironmentVariables)([
            this.id,
        ]);
        const gitEnv = (0, utils_1.getChildEnv)({ env: gitSubmoduleAuthEnvironmentVariables });
        const git = (0, simple_git_1.simpleGit)((0, config_1.simpleGitConfig)()).env(gitEnv);
        // fetch remote tags
        const lsRemote = await git.listRemote([
            (0, url_1.getRemoteUrlWithToken)(packageName, this.id),
        ]);
        if (!lsRemote) {
            return null;
        }
        const refs = lsRemote
            .trim()
            .split(regex_1.newlineRegex)
            .map((line) => line.trim())
            .map((line) => {
            let match = refMatch.exec(line);
            if (match?.groups) {
                return {
                    type: match.groups.type,
                    value: match.groups.value,
                    hash: match.groups.hash,
                };
            }
            match = headMatch.exec(line);
            if (match?.groups) {
                return {
                    type: '',
                    value: 'HEAD',
                    hash: match.groups.hash,
                };
            }
            logger_1.logger.trace(`malformed ref: ${line}`);
            return null;
        })
            .filter(is_1.default.truthy)
            .filter((ref) => ref.type !== 'pull' && !ref.value.endsWith('^{}'));
        return refs;
    }
}
exports.GitDatasource = GitDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${gitId}`,
        key: ({ packageName }) => packageName,
    })
], GitDatasource.prototype, "getRawRefs", null);
//# sourceMappingURL=base.js.map