"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GalaxyV3DetailedVersion = exports.GalaxyV3Versions = exports.GalaxyV3 = void 0;
const zod_1 = require("zod");
const timestamp_1 = require("../../../util/timestamp");
exports.GalaxyV3 = zod_1.z.object({
    deprecated: zod_1.z.boolean(),
    highest_version: zod_1.z.object({
        version: zod_1.z.string(),
    }),
});
exports.GalaxyV3Versions = zod_1.z
    .object({
    data: zod_1.z.array(zod_1.z.object({
        version: zod_1.z.string(),
        created_at: timestamp_1.MaybeTimestamp,
    })),
})
    .transform(({ data }) => {
    return data.map((value) => {
        return {
            version: value.version,
            releaseTimestamp: value.created_at,
        };
    });
});
exports.GalaxyV3DetailedVersion = zod_1.z
    .object({
    version: zod_1.z.string(),
    download_url: zod_1.z.string(),
    artifact: zod_1.z.object({
        sha256: zod_1.z.string(),
    }),
    metadata: zod_1.z.object({
        homepage: zod_1.z.string().optional(),
        repository: zod_1.z.string(),
        dependencies: zod_1.z.record(zod_1.z.string(), zod_1.z.string()).optional(),
    }),
})
    .transform((value) => {
    return {
        version: value.version,
        downloadUrl: value.download_url,
        newDigest: value.artifact.sha256,
        dependencies: value.metadata.dependencies,
        sourceUrl: value.metadata.repository,
    };
});
//# sourceMappingURL=schema.js.map