import { z } from 'zod';
export type GalaxyV3 = z.infer<typeof GalaxyV3>;
export declare const GalaxyV3: z.ZodObject<{
    deprecated: z.ZodBoolean;
    highest_version: z.ZodObject<{
        version: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        version: string;
    }, {
        version: string;
    }>;
}, "strip", z.ZodTypeAny, {
    deprecated: boolean;
    highest_version: {
        version: string;
    };
}, {
    deprecated: boolean;
    highest_version: {
        version: string;
    };
}>;
export type GalaxyV3Versions = z.infer<typeof GalaxyV3Versions>;
export declare const GalaxyV3Versions: z.ZodEffects<z.ZodObject<{
    data: z.ZodArray<z.ZodObject<{
        version: z.ZodString;
        created_at: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
    }, "strip", z.ZodTypeAny, {
        version: string;
        created_at: import("../../../util/timestamp").Timestamp | null;
    }, {
        version: string;
        created_at?: unknown;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    data: {
        version: string;
        created_at: import("../../../util/timestamp").Timestamp | null;
    }[];
}, {
    data: {
        version: string;
        created_at?: unknown;
    }[];
}>, {
    version: string;
    releaseTimestamp: import("../../../util/timestamp").Timestamp | null;
}[], {
    data: {
        version: string;
        created_at?: unknown;
    }[];
}>;
export type GalaxyV3DetailedVersion = z.infer<typeof GalaxyV3DetailedVersion>;
export declare const GalaxyV3DetailedVersion: z.ZodEffects<z.ZodObject<{
    version: z.ZodString;
    download_url: z.ZodString;
    artifact: z.ZodObject<{
        sha256: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        sha256: string;
    }, {
        sha256: string;
    }>;
    metadata: z.ZodObject<{
        homepage: z.ZodOptional<z.ZodString>;
        repository: z.ZodString;
        dependencies: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        repository: string;
        homepage?: string | undefined;
        dependencies?: Record<string, string> | undefined;
    }, {
        repository: string;
        homepage?: string | undefined;
        dependencies?: Record<string, string> | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    version: string;
    metadata: {
        repository: string;
        homepage?: string | undefined;
        dependencies?: Record<string, string> | undefined;
    };
    download_url: string;
    artifact: {
        sha256: string;
    };
}, {
    version: string;
    metadata: {
        repository: string;
        homepage?: string | undefined;
        dependencies?: Record<string, string> | undefined;
    };
    download_url: string;
    artifact: {
        sha256: string;
    };
}>, {
    version: string;
    downloadUrl: string;
    newDigest: string;
    dependencies: Record<string, string> | undefined;
    sourceUrl: string;
}, {
    version: string;
    metadata: {
        repository: string;
        homepage?: string | undefined;
        dependencies?: Record<string, string> | undefined;
    };
    download_url: string;
    artifact: {
        sha256: string;
    };
}>;
