import { Datasource } from '../datasource';
import type { GetReleasesConfig, Release, ReleaseResult } from '../types';
export declare class GalaxyCollectionDatasource extends Datasource {
    static readonly id = "galaxy-collection";
    constructor();
    readonly customRegistrySupport = true;
    readonly registryStrategy = "hunt";
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "pep440";
    readonly releaseTimestampSupport = true;
    releaseTimestampNote: string;
    readonly sourceUrlSupport = "release";
    readonly sourceUrlNote = "The `sourceUrl` is determined from the `repository` field in the results.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    constructBaseUrl(registryUrl: string, packageName: string): string;
    getVersionDetails(packageName: string, versionsUrl: string, basicRelease: Release): Promise<Release>;
}
